# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1447-1 (tomcat5.5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60102);
 script_cve_id("CVE-2007-3382", "CVE-2007-3385", "CVE-2007-3386", "CVE-2007-5342", "CVE-2007-5461");
 script_version ("$");
 name = "Debian Security Advisory DSA 1447-1 (tomcat5.5)";
 script_name(name);

 desc = "The remote host is missing an update to tomcat5.5
announced via advisory DSA 1447-1.

Several remote vulnerabilities have been discovered in the Tomcat
servlet and JSP engine. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2007-3382

It was discovered that single quotes (') in cookies were treated
as a delimiter, which could lead to an information leak.

CVE-2007-3385

It was discovered that the character sequence \ in cookies was
handled incorrectly, which could lead to an information leak.

CVE-2007-3386

It was discovered that the host manager servlet performed
insufficient input validation, which could lead to cross-site
scripting.

CVE-2007-5342

It was discovered that the JULI logging component did not restrict
its target path, resulting in potential denial of service through
file overwrites.

CVE-2007-5461

It was discovered that the WebDAV servlet is vulnerable to absolute
path traversal.

For the stable distribution (etch), these problems have been fixed in
version 5.5.20-2etch1.

The old stable distribution (sarge) doesn't contain tomcat5.5.

The unstable distribution (sid) will be fixed soon.

We recommend that you upgrade your tomcat5.5 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201447-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1447-1 (tomcat5.5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtomcat5.5-java", ver:"5.5.20-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat5.5-webapps", ver:"5.5.20-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat5.5", ver:"5.5.20-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat5.5-admin", ver:"5.5.20-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
