# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 145-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53726);
 script_cve_id("CVE-2002-0847");
 script_bugtraq_id(4731);
 script_version ("$");
 name = "Debian Security Advisory DSA 145-1 (tinyproxy)";
 script_name(name);

 desc = "The remote host is missing an update to tinyproxy
announced via advisory DSA 145-1.

The authors of tinyproxy, a lightweight HTTP proxy, discovered a bug
in the handling of some invalid proxy requests.  Under some
circumstances, an invalid request may result in a allocated memory
being freed twice.  This can potentially result in the execution of
arbitrary code.

This problem has been fixed in version 1.4.3-2woody2 for the current
stable distribution (woody) and in version 1.4.3-3 for the unstable
distribution (sid).  The old stable distribution (potato) is not
affected by this problem.

We recommend that you upgrade your tinyproxy package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20145-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 145-1 (tinyproxy)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tinyproxy", ver:"1.4.3-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
