# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 147-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53415);
 script_cve_id("CVE-2002-0388");
 script_version ("$");
 name = "Debian Security Advisory DSA 147-2 (mailman)";
 script_name(name);

 desc = "The remote host is missing an update to mailman
announced via advisory DSA 147-2.

Quoting DSA 147-1:

A cross-site scripting vulnerability was discovered in mailman, a
software to manage electronic mailing lists.  When a properly
crafted URL is accessed with Internet Explorer (other browsers
don't seem to be affected), the resulting webpage is rendered
similar to the real one, but the javascript component is executed
as well, which could be used by an attacker to get access to
sensitive information.  The new version for Debian 2.2 also
includes backports of security related patches from mailman 2.0.11.

This has been fixed in DSA 147-1 already, however, contrary to popular
belief, it turned out that the Python packaging does not upgrade
Python 1.5 users to 2.1 when upgrading from potato to woody.  It also
turned out that the mailman security update unwittingly introduced a
dependency to Python 2.1, both in the security update and upstream,
which left the package unusable on some systems.

This problem has been fixed in version 2.0.11-1woody4 for the current
stable distribution (woody).  Others are not affected.

We recommend that you upgrade your mailman package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20147-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 147-2 (mailman)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mailman", ver:"2.0.11-1woody4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
