# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1509-1 (koffice)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60443);
 script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
 script_version ("$");
 name = "Debian Security Advisory DSA 1509-1 (koffice)";
 script_name(name);

 desc = "The remote host is missing an update to koffice
announced via advisory DSA 1509-1.

Several vulnerabilities have been discovered in xpdf code that is
embedded in koffice, an integrated office suite for KDE.  These flaws
could allow an attacker to execute arbitrary code by inducing the user
to import a specially crafted PDF document.

The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2007-4352

Array index error in the DCTStream::readProgressiveDataUnit method in
xpdf/Stream.cc in Xpdf 3.02pl1, as used in poppler, teTeX, KDE, KOffice,
CUPS, and other products, allows remote attackers to trigger memory
corruption and execute arbitrary code via a crafted PDF file.

CVE-2007-5392

Integer overflow in the DCTStream::reset method in xpdf/Stream.cc in
Xpdf 3.02p11 allows remote attackers to execute arbitrary code via a
crafted PDF file, resulting in a heap-based buffer overflow.

CVE-2007-5393

Heap-based buffer overflow in the CCITTFaxStream::lookChar method in
xpdf/Stream.cc in Xpdf 3.02p11 allows remote attackers to execute
arbitrary code via a PDF file that contains a crafted CCITTFaxDecode
filter.

For the stable distribution (etch), these problems have been fixed in version
1:1.6.1-2etch2.

Updates for the old stable distribution (sarge), will be made available
as soon as possible.

We recommend that you upgrade your koffice package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201509-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1509-1 (koffice)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"koffice-data", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kword-data", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kivio-data", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-doc", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-doc-html", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpresenter-data", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krita-data", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-dbg", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kword", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kexi", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-dev", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"karbon", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koshell", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kspread", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kivio", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kplato", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kugar", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kchart", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krita", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpresenter", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kthesaurus", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-libs", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kformula", ver:"1.6.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
