# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 150-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53410);
 script_version ("$");
 name = "Debian Security Advisory DSA 150-1 (interchange)";
 script_name(name);

 desc = "The remote host is missing an update to interchange
announced via advisory DSA 150-1.

A problem has been discovered in Interchange, an e-commerce and
general HTTP database display system, which can lead to an attacker
being able to read any file to which the user of the Interchange
daemon has sufficient permissions, when Interchange runs in INET
mode (internet domain socket).  This is not the default setting in
Debian packages, but configurable with Debconf and via configuration
file.  We also believe that this bug cannot exploited on a regular
Debian system.

This problem has been fixed by the package maintainer in version
4.8.3.20020306-1.woody.1 for the current stable distribution (woody)
and in version 4.8.6-1 for the unstable distribution (sid).  The old
stable distribution (potato) is not affected, since it doesn't ship
the Interchange system.

We recommend that you upgrade your interchange packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20150-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 150-1 (interchange)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"interchange-cat-foundation", ver:"4.8.3.20020306-1.woody.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"interchange-ui", ver:"4.8.3.20020306-1.woody.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"interchange", ver:"4.8.3.20020306-1.woody.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-interchange", ver:"4.8.3.20020306-1.woody.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
