# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1514-1 (moin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60500);
 script_cve_id("CVE-2007-2423", "CVE-2007-2637", "CVE-2008-0780", "CVE-2008-0781", "CVE-2008-0782", "CVE-2008-1098", "CVE-2008-1099");
 script_version ("$");
 name = "Debian Security Advisory DSA 1514-1 (moin)";
 script_name(name);

 desc = "The remote host is missing an update to moin
announced via advisory DSA 1514-1.

Several remote vulnerabilities have been discovered in MoinMoin, a
Python clone of WikiWiki. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2007-2423

A cross-site-scripting vulnerability has been discovered in
attachment handling.

CVE-2007-2637

Access control lists for calendars and includes were
insufficiently enforced, which could lead to information
disclosure.

CVE-2008-0780

A cross-site-scripting vulnerability has been discovered in
the login code.

CVE-2008-0781

A cross-site-scripting vulnerability has been discovered in
attachment handling.

CVE-2008-0782

A directory traversal vulnerability in cookie handling could
lead to local denial of service by overwriting files.

CVE-2008-1098

Cross-site-scripting vulnerabilities have been discovered in
the GUI editor formatter and the code to delete pages.

CVE-2008-1099

The macro code validates access control lists insufficiently,
which could lead to information disclosure.


For the stable distribution (etch), these problems have been fixed in
version 1.5.3-1.2etch1. This update also includes a bugfix wrt the
encoding of password reminder mails, which doesn't have security
implications.

The old stable distribution (sarge) will not be updated due to
the many changes and support for Sarge ending end of this month
anyway. You're advised to upgrade to the stable distribution if
you run moinmoin.

We recommend that you upgrade your moin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201514-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1514-1 (moin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.3-1.2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.3-1.2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
