# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1528-1 (serendipity)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60618);
 script_cve_id("CVE-2007-6205", "CVE-2008-0124");
 script_bugtraq_id(28298);
 script_version ("$");
 name = "Debian Security Advisory DSA 1528-1 (serendipity)";
 script_name(name);

 desc = "The remote host is missing an update to serendipity
announced via advisory DSA 1528-1.

Peter Hwe and Hanno Bck discovered that Serendipity, a weblog manager,
did not properly sanitise input to several scripts which allowed for
cross site scripting.

For the stable distribution (etch), this problem has been fixed in version
1.0.4-1+etch1.

The old stable distribution (sarge) does not contain a serendipity package.

For the unstable distribution (sid), this problem has been fixed in
version 1.3-1.

We recommend that you upgrade your serendipity package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201528-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1528-1 (serendipity)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"serendipity", ver:"1.0.4-1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
