# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1564-1 (wordpress)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60930);
 script_cve_id("CVE-2007-3639", "CVE-2007-4153", "CVE-2007-4154", "CVE-2007-0540");
 script_version ("$");
 name = "Debian Security Advisory DSA 1564-1 (wordpress)";
 script_name(name);

 desc = "The remote host is missing an update to wordpress
announced via advisory DSA 1564-1.

Several remote vulnerabilities have been discovered in wordpress,
a weblog manager. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2007-3639

Insufficient input sanitising allowed for remote attackers to
redirect visitors to external websites.

CVE-2007-4153

Multiple cross-site scripting vulnerabilities allowed remote
authenticated administrators to inject arbitrary web script or HTML.

CVE-2007-4154

SQL injection vulnerability allowed allowed remote authenticated
administrators to execute arbitrary SQL commands.

CVE-2007-0540

WordPress allows remote attackers to cause a denial of service
(bandwidth or thread consumption) via pingback service calls with
a source URI that corresponds to a file with a binary content type,
which is downloaded even though it cannot contain usable pingback data.

[no CVE name yet]

Insufficient input sanitising caused an attacker with a normal user
account to access the administrative interface.


For the stable distribution (etch), these problems have been fixed in
version 2.0.10-1etch2.

For the unstable distribution (sid), these problems have been fixed in
version 2.2.3-1.

We recommend that you upgrade your wordpress package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201564-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1564-1 (wordpress)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wordpress", ver:"2.0.10-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
