# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1595-1 (xorg-server)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61171);
 script_cve_id("CVE-2008-1377", "CVE-2008-1379", "CVE-2008-2360", "CVE-2008-2361", "CVE-2008-2362");
 script_version ("$");
 name = "Debian Security Advisory DSA 1595-1 (xorg-server)";
 script_name(name);

 desc = "The remote host is missing an update to xorg-server
announced via advisory DSA 1595-1.

Several local vulnerabilities have been discovered in the X Window system.
The Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2008-1377

Lack of validation of the parameters of the
SProcSecurityGenerateAuthorization SProcRecordCreateContext
functions makes it possible for a specially crafted request to trigger
the swapping of bytes outside the parameter of these requests, causing
memory corruption.

CVE-2008-1379

An integer overflow in the validation of the parameters of the
ShmPutImage() request makes it possible to trigger the copy of
arbitrary server memory to a pixmap that can subsequently be read by
the client, to read arbitrary parts of the X server memory space.

CVE-2008-2360

An integer overflow may occur in the computation of the size of the
glyph to be allocated by the AllocateGlyph() function which will cause
less memory to be allocated than expected, leading to later heap
overflow.

CVE-2008-2361

An integer overflow may occur in the computation of the  size of the
glyph to be allocated by the ProcRenderCreateCursor() function which
will cause less memory to be allocated than expected, leading later
to dereferencing un-mapped memory, causing a crash of the X server.

CVE-2008-2362

Integer overflows can also occur in the code validating the parameters
for the SProcRenderCreateLinearGradient, SProcRenderCreateRadialGradient
and SProcRenderCreateConicalGradient functions, leading to memory
corruption by swapping bytes outside of the intended request
parameters.

For the stable distribution (etch), these problems have been fixed in version
2:1.1.1-21etch5.

For the unstable distribution (sid), these problems have been fixed in
version 2:1.4.1~git20080517-2.

We recommend that you upgrade your xorg-server package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201595-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1595-1 (xorg-server)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.1.1-21etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.1.1-21etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xdmx", ver:"1.1.1-21etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xnest", ver:"1.1.1-21etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xvfb", ver:"1.1.1-21etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xdmx-tools", ver:"1.1.1-21etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-xephyr", ver:"1.1.1-21etch5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
