# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1616-2 (clamav)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61369);
 script_cve_id("CVE-2008-2713");
 script_version ("$");
 name = "Debian Security Advisory DSA 1616-2 (clamav)";
 script_name(name);

 desc = "The remote host is missing an update to clamav
announced via advisory DSA 1616-2.

This update corrects a packaging and build error in the packages
released in DSA-1616-1.  Those packages, while functional, did not
actually apply the fix intended.  This update restores the fix
to the package build; no other changes are introduced.  For
reference, the text of the original advisory follows.

Damian Put discovered a vulnerability in the ClamAV anti-virus
toolkit's parsing of Petite-packed Win32 executables.  The weakness
leads to an invalid memory access, and could enable an attacker to
crash clamav by supplying a maliciously crafted Petite-compressed
binary for scanning.  In some configurations, such as when clamav
is used in combination with mail servers, this could cause a system
to fail open, facilitating a follow-on viral attack.

The Common Vulnerabilities and Exposures project identifies this
weakness as CVE-2008-2713.

For the stable distribution (etch), this problem has been fixed in
version 0.90.1dfsg-3.1+etch14.  For the unstable distribution (sid),
the problem has been fixed in version 0.93.1.dfsg-1.1.

We recommend that you upgrade your clamav packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201616-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1616-2 (clamav)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-base", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-dbg", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav2", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.90.1dfsg-3.1+etch14", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
