# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 161-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53419);
 script_version ("$");
 name = "Debian Security Advisory DSA 161-1 (mantis)";
 script_name(name);

 desc = "The remote host is missing an update to mantis
announced via advisory DSA 161-1.

A problem with user privileges has been discovered in the Mantis
package, a PHP based bug tracking system.  The Mantis system didn't
check whether a user is permitted to view a bug, but displays it right
away if the user entered a valid bug id.

Another bug in Mantis caused the 'View Bugs' page to list bugs from
both public and private projects when no projects are accessible to
the current user.

These problems have been fixed in version 0.17.1-2.5 for the current
stable distribution (woody) and in version 0.17.5-2 for the unstable
distribution (sid).  The old stable distribution (potato) is not
affected, since it doesn't contain the mantis package.

We recommend that you upgrade your mantis packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20161-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 161-1 (mantis)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mantis", ver:"0.17.1-2.5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
