# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1620-1 (python2.5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61372);
 script_cve_id("CVE-2007-2052", "CVE-2007-4965", "CVE-2008-1679", "CVE-2008-1721", "CVE-2008-1887");
 script_version ("$");
 name = "Debian Security Advisory DSA 1620-1 (python2.5)";
 script_name(name);

 desc = "The remote host is missing an update to python2.5
announced via advisory DSA 1620-1.

Several vulnerabilities have been discovered in the interpreter for the
Python language. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2007-2052

Piotr Engelking discovered that the strxfrm() function of the locale
module miscalculates the length of an internal buffer, which may
result in a minor information disclosure.

CVE-2007-4965

It was discovered that several integer overflows in the imageop
module may lead to the execution of arbitrary code, if a user is
tricked into processing malformed images. This issue is also
tracked as CVE-2008-1679 due to an initially incomplete patch.

CVE-2008-1721

Justin Ferguson discovered that a buffer overflow in the zlib
module may lead to the execution of arbitrary code.

CVE-2008-1887

Justin Ferguson discovered that insufficient input validation in
PyString_FromStringAndSize() may lead to the execution of arbitrary
code.

For the stable distribution (etch), these problems have been fixed in
version 2.5-5+etch1.

For the unstable distribution (sid), these problems have been fixed in
version 2.5.2-3.

We recommend that you upgrade your python2.5 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201620-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1620-1 (python2.5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5", ver:"2.5-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
