# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1652-1 (ruby1.9)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61774);
 script_cve_id("CVE-2008-3655", "CVE-2008-3656", "CVE-2008-3657", "CVE-2008-3790", "CVE-2008-3905");
 script_version ("$");
 name = "Debian Security Advisory DSA 1652-1 (ruby1.9)";
 script_name(name);

 desc = "The remote host is missing an update to ruby1.9
announced via advisory DSA 1652-1.

Several vulnerabilities have been discovered in the interpreter for
the Ruby language, which may lead to denial of service and other
security problems. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2008-3655

Keita Yamaguchi discovered that several safe level restrictions
are insufficiently enforced.

CVE-2008-3656

Christian Neukirchen discovered that the WebRick module uses
inefficient algorithms for HTTP header splitting, resulting in
denial of service through resource exhaustion.

CVE-2008-3657

It was discovered that the dl module doesn't perform taintness
checks.

CVE-2008-3790

Luka Treiber and Mitja Kolsek discovered that recursively nested
XML entities can lead to denial of service through resource
exhaustion in rexml.

CVE-2008-3905

Tanaka Akira discovered that the resolv module uses sequential
transaction IDs and a fixed source port for DNS queries, which
makes it more vulnerable to DNS spoofing attacks.

For the stable distribution (etch), these problems have been fixed in
version 1.9.0+20060609-1etch3. Packages for arm will be provided later.

For the unstable distribution (sid), these problems have been fixed in
version 1.9.0.2-6.

We recommend that you upgrade your ruby1.9 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201652-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1652-1 (ruby1.9)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"rdoc1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irb1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-examples", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-elisp", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ri1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.9-dbg", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.9", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-dev", ver:"1.9.0+20060609-1etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
