# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1660-1 (clamav)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61782);
 script_cve_id("CVE-2008-3912", "CVE-2008-3913", "CVE-2008-3914");
 script_version ("$");
 name = "Debian Security Advisory DSA 1660-1 (clamav)";
 script_name(name);

 desc = "The remote host is missing an update to clamav
announced via advisory DSA 1660-1.

Several denial-of-service vulnerabilities have been discovered in
the ClamAV anti-virus toolkit:

Insufficient checking for out-of-memory conditions results in null
pointer derefences (CVE-2008-3912).

Incorrect error handling logic leads to memory leaks (CVE-2008-3913)
and file descriptor leaks (CVE-2008-3914).

For the stable distribution (etch), these problems have been fixed in
version 0.90.1dfsg-4etch15.

For the unstable distribution (sid) and the testing distribution
(lenny), these problems have been fixed in version 0.94.dfsg-1.

We recommend that you upgrade your clamav package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201660-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1660-1 (clamav)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-base", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav2", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-dbg", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.90.1dfsg-4etch15", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
