# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1663-1 (net-snmp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61853);
 script_cve_id("CVE-2008-0960", "CVE-2008-2292", "CVE-2008-4309");
 script_version ("$");
 name = "Debian Security Advisory DSA 1663-1 (net-snmp)";
 script_name(name);

 desc = "The remote host is missing an update to net-snmp
announced via advisory DSA 1663-1.

Several vulnerabilities have been discovered in NET SNMP, a suite of
Simple Network Management Protocol applications. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2008-0960

Wes Hardaker reported that the SNMPv3 HMAC verification relies on
the client to specify the HMAC length, which allows spoofing of
authenticated SNMPv3 packets.

CVE-2008-2292

John Kortink reported a buffer overflow in the __snprint_value
function in snmp_get causing a denial of service and potentially
allowing the execution of arbitrary code via a large OCTETSTRING
in an attribute value pair (AVP).

CVE-2008-4309

It was reported that an integer overflow in the
netsnmp_create_subtree_cache function in agent/snmp_agent.c allows
remote attackers to cause a denial of service attack via a crafted
SNMP GETBULK request.

For the stable distribution (etch), these problems has been fixed in
version 5.2.3-7etch4.

For the testing distribution (lenny) and unstable distribution (sid)
these problems have been fixed in version 5.4.1~dfsg-11.

We recommend that you upgrade your net-snmp package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201663-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1663-1 (net-snmp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsnmp-base", ver:"5.2.3-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tkmib", ver:"5.2.3-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsnmp9-dev", ver:"5.2.3-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"snmp", ver:"5.2.3-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsnmp9", ver:"5.2.3-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsnmp-perl", ver:"5.2.3-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"snmpd", ver:"5.2.3-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
