# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1669-1 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61907);
 script_cve_id("CVE-2008-0016", "CVE-2008-3835", "CVE-2008-3836", "CVE-2008-3837", "CVE-2008-4058", "CVE-2008-4059", "CVE-2008-4060", "CVE-2008-4061", "CVE-2008-4062", "CVE-2008-4065", "CVE-2008-4066", "CVE-2008-4067", "CVE-2008-4068", "CVE-2008-4069", "CVE-2008-4582", "CVE-2008-5012", "CVE-2008-5013", "CVE-2008-5014", "CVE-2008-5017", "CVE-2008-5018", "CVE-2008-0017", "CVE-2008-5021", "CVE-2008-5022", "CVE-2008-5023", "CVE-2008-5024");
 script_version ("$");
 name = "Debian Security Advisory DSA 1669-1 (xulrunner)";
 script_name(name);

 desc = "The remote host is missing an update to xulrunner
announced via advisory DSA 1669-1.

Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications. For details on the issues
addressed with this update, please visit the referenced security
advisories.

For the stable distribution (etch), these problems have been fixed in
version 1.8.0.15~pre080614h-0etch1. Packages for mips will be provided
later.

For the upcoming stable distribution (lenny) and the unstable
distribution (sid), these problems have been fixed in version 1.9.0.4-1.

We recommend that you upgrade your xulrunner packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201669-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1669-1 (xulrunner)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsmjs-dev", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-dev", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs-dev", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmjs1", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul-dev", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul-common", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozillainterfaces-java", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-dev", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs0d", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul0d", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs0d-dbg", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-tools", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d-dbg", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"spidermonkey-bin", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-gnome-support", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-0d-dbg", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-0d", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-xpcom", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul0d-dbg", ver:"1.8.0.15~pre080614h-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
