# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1690-1 (avahi)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63062);
 script_cve_id("CVE-2007-3372", "CVE-2008-5081");
 script_version ("$");
 name = "Debian Security Advisory DSA 1690-1 (avahi)";
 script_name(name);

 desc = "The remote host is missing an update to avahi
announced via advisory DSA 1690-1.

Two denial of service conditions were discovered in avahi, a Multicast
DNS implementation.

Huge Dias discovered that the avahi daemon aborts with an assert error
if it encounters a UDP packet with source port 0 (CVE-2008-5081).

It was discovered that the avahi daemon aborts with an assert error if
it receives an empty TXT record over D-Bus (CVE-2007-3372).

For the stable distribution (etch), these problems have been fixed in
version 0.6.16-3etch2.

For the unstable distribution (sid), these problems have been fixed in
version 0.6.23-3.

We recommend that you upgrade your avahi packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201690-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1690-1 (avahi)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"avahi-discover", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-avahi", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-core4", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-compat-howl0", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-common-data", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-qt3-1", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-qt4-dev", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-client-dev", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-compat-libdnssd-dev", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"avahi-dnsconfd", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-glib1", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-common3", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-core-dev", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"avahi-daemon", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-qt4-1", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-qt3-dev", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-client3", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-compat-howl-dev", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-compat-libdnssd1", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-glib-dev", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavahi-common-dev", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"avahi-utils", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"avahi-autoipd", ver:"0.6.16-3etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
