# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1691-1 (moodle)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63060);
 script_cve_id("CVE-2007-3555", "CVE-2008-1502", "CVE-2008-3325", "CVE-2008-3326", "CVE-2008-4796", "CVE-2008-4810", "CVE-2008-4811", "CVE-2008-5432");
 script_version ("$");
 name = "Debian Security Advisory DSA 1691-1 (moodle)";
 script_name(name);

 desc = "The remote host is missing an update to moodle
announced via advisory DSA 1691-1.

Several remote vulnerabilities have been discovered in Moodle, an online
course management system. The following issues are addressed in this
update, ranging from cross site scripting to remote code execution.

Various cross site scripting issues in the Moodle codebase
(CVE-2008-3326, CVE-2008-3325, CVE-2007-3555, CVE-2008-5432,
MSA-08-0021, MDL-8849, MDL-12793, MDL-11414, MDL-14806,
MDL-10276).

Various cross site request forgery issues in the Moodle codebase
(CVE-2008-3325, MSA-08-0023).

Privilege escalation bugs in the Moodle codebase (MSA-08-0001, MDL-7755).

SQL injection issue in the hotpot module (MSA-08-0010).

An embedded copy of Smarty had several vulnerabilities
(CVE-2008-4811, CVE-2008-4810).
An embedded copy of Snoopy was vulnerable to cross site scripting
(CVE-2008-4796).
An embedded copy of Kses was vulnerable to cross site scripting
(CVE-2008-1502).

For the stable distribution (etch), these problems have been fixed in
version 1.6.3-2+etch1.

For the unstable distribution (sid), these problems have been fixed in
version 1.8.2.dfsg-2.

We recommend that you upgrade your moodle (1.6.3-2+etch1) package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201691-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1691-1 (moodle)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"moodle", ver:"1.6.3-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
