# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1702-1 (ntp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63149);
 script_cve_id("CVE-2009-0021");
 script_version ("$");
 name = "Debian Security Advisory DSA 1702-1 (ntp)";
 script_name(name);

 desc = "The remote host is missing an update to ntp
announced via advisory DSA 1702-1.

It has been discovered that NTP, an implementation of the Network Time
Protocol, does not properly check the result of an OpenSSL function
for verifying cryptographic signatures, which may ultimately lead to
the acceptance of unauthenticated time information.  (Note that
cryptographic authentication of time servers is often not enabled in
the first place.)

For the stable distribution (etch), this problem has been fixed in
version 4.2.2.p4+dfsg-2etch1.

For the unstable distribution (sid), this problem has been fixed in
version 4.2.4p4+dfsg-8.

The testing distribution (lenny) will be fixed soon.

We recommend that you upgrade your ntp package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201702-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1702-1 (ntp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.2.p4+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-simple", ver:"4.2.2.p4+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-refclock", ver:"4.2.2.p4+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.2.p4+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.2.p4+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
