# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1789-1 (php5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63954);
 script_cve_id("CVE-2008-2107", "CVE-2008-2108", "CVE-2008-5557", "CVE-2008-5624", "CVE-2008-5658", "CVE-2008-5814", "CVE-2009-0754", "CVE-2009-1271");
 script_version ("$");
 name = "Debian Security Advisory DSA 1789-1 (php5)";
 script_name(name);

 desc = "The remote host is missing an update to php5
announced via advisory DSA 1789-1.

Several remote vulnerabilities have been discovered in the PHP 5
hypertext preprocessor. The Common Vulnerabilities and Exposures
project identifies the following problems.

The following four vulnerabilities have already been fixed in the stable
(lenny) version of php5 prior to the release of lenny. This update now
addresses them for etch (oldstable) aswell:

CVE-2008-2107 / CVE-2008-2108

The GENERATE_SEED macro has several problems that make predicting
generated random numbers easier, facilitating attacks against measures
that use rand() or mt_rand() as part of a protection.

CVE-2008-5557

A buffer overflow in the mbstring extension allows attackers to execute
arbitrary code via a crafted string containing an HTML entity.

CVE-2008-5624

The page_uid and page_gid variables are not correctly set, allowing
use of some functionality intended to be restricted to root.

CVE-2008-5658

Directory traversal vulnerability in the ZipArchive::extractTo function
allows attackers to write arbitrary files via a ZIP file with a file
whose name contains .. (dot dot) sequences.

This update also addresses the following three vulnerabilities for both
oldstable (etch) and stable (lenny):

CVE-2008-5814

Cross-site scripting (XSS) vulnerability, when display_errors is enabled,
allows remote attackers to inject arbitrary web script or HTML.

CVE-2009-0754

When running on Apache, PHP allows local users to modify behavior of
other sites hosted on the same web server by modifying the
mbstring.func_overload setting within .htaccess, which causes this
setting to be applied to other virtual hosts on the same server.

CVE-2009-1271

The JSON_parser function allows a denial of service (segmentation fault)
via a malformed string to the json_decode API function.

Furthermore, two updates originally scheduled for the next point update for
oldstable are included in the etch package:

* Let PHP use the system timezone database instead of the embedded
timezone database which is out of date.

* From the source tarball, the unused 'dbase' module has been removed
which contained licensing problems.

For the old stable distribution (etch), these problems have been fixed in
version 5.2.0+dfsg-8+etch15.

For the stable distribution (lenny), these problems have been fixed in
version 5.2.6.dfsg.1-1+lenny3.

For the unstable distribution (sid), these problems have been fixed in
version 5.2.9.dfsg.1-1.

We recommend that you upgrade your php5 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201789-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1789-1 (php5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php5", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php5", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mcrypt", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-imap", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-interbase", ver:"5.2.0+dfsg-8+etch15", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mcrypt", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gmp", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-imap", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dbg", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5filter", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-interbase", ver:"5.2.6.dfsg.1-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
