# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1793-1 (kdegraphics)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63958);
 script_cve_id("CVE-2009-0146", "CVE-2009-0147", "CVE-2009-0165", "CVE-2009-0166", "CVE-2009-0799", "CVE-2009-0800", "CVE-2009-1179", "CVE-2009-1180", "CVE-2009-1181", "CVE-2009-1182", "CVE-2009-1183");
 script_version ("$");
 name = "Debian Security Advisory DSA 1793-1 (kdegraphics)";
 script_name(name);

 desc = "The remote host is missing an update to kdegraphics
announced via advisory DSA 1793-1.

kpdf, a Portable Document Format (PDF) viewer for KDE, is based on the
xpdf program and thus suffers from similar flaws to those described in
DSA-1790.

The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2009-0146

Multiple buffer overflows in the JBIG2 decoder in kpdf allow
remote attackers to cause a denial of service (crash) via a
crafted PDF file, related to (1) JBIG2SymbolDict::setBitmap and
(2) JBIG2Stream::readSymbolDictSeg.

CVE-2009-0147

Multiple integer overflows in the JBIG2 decoder in kpdf allow
remote attackers to cause a denial of service (crash) via a
crafted PDF file, related to (1) JBIG2Stream::readSymbolDictSeg,
(2) JBIG2Stream::readSymbolDictSeg, and (3)
JBIG2Stream::readGenericBitmap.

CVE-2009-0165

Integer overflow in the JBIG2 decoder in kpdf has unspecified
impact related to g*allocn.

CVE-2009-0166

The JBIG2 decoder in kpdf allows remote attackers to cause a
denial of service (crash) via a crafted PDF file that triggers a
free of uninitialized memory.

CVE-2009-0799

The JBIG2 decoder in kpdf allows remote attackers to cause a
denial of service (crash) via a crafted PDF file that triggers an
out-of-bounds read.

CVE-2009-0800

Multiple input validation flaws in the JBIG2 decoder in kpdf
allow remote attackers to execute arbitrary code via a crafted PDF
file.

CVE-2009-1179

Integer overflow in the JBIG2 decoder in kpdf allows remote
attackers to execute arbitrary code via a crafted PDF file.

CVE-2009-1180

The JBIG2 decoder in kpdf allows remote attackers to execute
arbitrary code via a crafted PDF file that triggers a free of
invalid data.

CVE-2009-1181

The JBIG2 decoder in kpdf allows remote attackers to cause a
denial of service (crash) via a crafted PDF file that triggers a
NULL pointer dereference.

CVE-2009-1182

Multiple buffer overflows in the JBIG2 MMR decoder in kpdf allow
remote attackers to execute arbitrary code via a crafted PDF file.

CVE-2009-1183

The JBIG2 MMR decoder in kpdf allows remote attackers to cause a
denial of service (infinite loop and hang) via a crafted PDF file.


We recommend that you upgrade your kdegraphics packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201793-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1793-1 (kdegraphics)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdegraphics-doc-html", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kgamma", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kiconedit", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpdf", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kooka", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolourpaint", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfaxview", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kuickshow", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmrml", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kghostview", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kviewshell", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfax", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan-dev", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kcoloredit", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kview", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kruler", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kamera", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dev", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksnapshot", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-kfile-plugins", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan1", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dbg", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpovmodeler", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdvi", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksvg", ver:"3.5.5-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-doc-html", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kview", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dbg", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-dev", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kviewshell", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kruler", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kooka", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kuickshow", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdegraphics-kfile-plugins", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kolourpaint", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpovmodeler", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksnapshot", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfaxview", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kghostview", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdvi", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksvg", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kcoloredit", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kamera", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan-dev", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmrml", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpdf", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kgamma", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkscan1", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfax", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kiconedit", ver:"3.5.9-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
