# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1795-1 (ldns)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63960);
 script_cve_id("CVE-2009-1086");
 script_version ("$");
 name = "Debian Security Advisory DSA 1795-1 (ldns)";
 script_name(name);

 desc = "The remote host is missing an update to ldns
announced via advisory DSA 1795-1.

Stefan Kaltenbrunner discovered that ldns, a library and set of utilities
to facilitate DNS programming, did not correctly implement a buffer
boundary check in its RR DNS record parser.  This weakness could enable
overflow of a heap buffer if a maliciously-crafted record is parsed,
potentially allowing the execution of arbitrary code.  The scope of
compromise will vary with the context in which ldns is used, and could
present either a local or remote attack vector.

The old stable distribution (etch) is not affected by this issue.

For the stable distribution (lenny), this problem has been fixed in
version 1.4.0-1+lenny1.

For the unstable distribution (sid), this problem was fixed in
version 1.5.1-1.

We recommend that you upgrade your ldns packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201795-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1795-1 (ldns)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ldnsutils", ver:"1.4.0-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libldns-dev", ver:"1.4.0-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libldns1", ver:"1.4.0-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
