# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1815-1 (libtorrent-rasterbar)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64249);
 script_cve_id("CVE-2009-1760");
 script_version ("$");
 name = "Debian Security Advisory DSA 1815-1 (libtorrent-rasterbar)";
 script_name(name);

 desc = "The remote host is missing an update to libtorrent-rasterbar
announced via advisory DSA 1815-1.

It was discovered that the Rasterbar Bittorrent library performed
insufficient validation of path names specified in torrent files, which
could lead to denial of service by overwriting files.

The old stable distribution (etch) doesn't include libtorrent-rasterbar.

For the stable distribution (lenny), this problem has been fixed in
version 0.13.1-2+lenny1.

For the unstable distribution (sid), this problem has been fixed in
version 0.14.4-1.

We recommend that you upgrade your libtorrent-rasterbar package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201815-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1815-1 (libtorrent-rasterbar)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtorrent-rasterbar-doc", ver:"0.13.1-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtorrent-rasterbar-dev", ver:"0.13.1-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtorrent-rasterbar0", ver:"0.13.1-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtorrent-rasterbar-dbg", ver:"0.13.1-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
