# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1816-1 (apache2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64251);
 script_cve_id("CVE-2009-1195");
 script_version ("$");
 name = "Debian Security Advisory DSA 1816-1 (apache2)";
 script_name(name);

 desc = "The remote host is missing an update to apache2
announced via advisory DSA 1816-1.

It was discovered that the Apache web server did not properly handle
the Options= parameter to the AllowOverride directive:

In the stable distribution (lenny), local users could (via .htaccess)
enable script execution in Server Side Includes even in configurations
where the AllowOverride directive contained only
Options=IncludesNoEXEC.

In the oldstable distribution (etch), local users could (via
.htaccess) enable script execution in Server Side Includes and CGI
script execution in configurations where the AllowOverride directive
contained any Options= value.

For the stable distribution (lenny), this problem has been fixed in
version 2.2.9-10+lenny3.

The oldstable distribution (etch), this problem has been fixed in
version 2.2.3-4+etch8.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem will be fixed in version 2.2.11-6.

This advisory also provides updated apache2-mpm-itk packages which
have been recompiled against the new apache2 packages (except for the
s390 architecture where updated packages will follow shortly).

We recommend that you upgrade your apache2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201816-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1816-1 (apache2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-itk", ver:"2.2.3-01-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.3-4+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec-custom", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-itk", ver:"2.2.6-02-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-dbg", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec", ver:"2.2.9-10+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
