# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1823-1 (samba)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64311);
 script_cve_id("CVE-2009-1886", "CVE-2009-1888");
 script_version ("$");
 name = "Debian Security Advisory DSA 1823-1 (samba)";
 script_name(name);

 desc = "The remote host is missing an update to samba
announced via advisory DSA 1823-1.

Several vulnerabilities have been discovered in Samba, a SMB/CIFS file,
print, and login server. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2009-1886

The smbclient utility contains a formatstring vulnerability where
commands dealing with file names treat user input as format strings
to asprintf.

CVE-2009-1888

In  the smbd daemon, if a user is trying to modify an access control
list (ACL) and is denied permission, this deny may be overridden if
the parameter dos filemode is set to yes in the smb.conf and the
user already has write access to the file.

The old stable distribution (etch) is not affected by these problems.

For the stable distribution (lenny), these problems have been fixed in
version 3.2.5-4lenny6.

The unstable distribution (sid), which is only affected by CVE-2009-1888,
will be fixed soon.

We recommend that you upgrade your samba package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201823-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1823-1 (samba)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-tools", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwbclient0", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.2.5-4lenny6", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
