# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1834-2 (apache2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64559);
 script_cve_id("CVE-2009-1890", "CVE-2009-1891");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1834-2 (apache2)");

 desc = "The remote host is missing an update to apache2
announced via advisory DSA 1834-2.

The previous update caused a regression for apache2 in Debian 4.0
etch. Using mod_deflate together with mod_php could cause segfaults
when a client aborts a connection. This update corrects this flaw.
For reference the original advisory text is below.


A denial of service flaw was found in the Apache mod_proxy module when
it was used as a reverse proxy. A remote attacker could use this flaw
to force a proxy process to consume large amounts of CPU time. This
issue did not affect Debian 4.0 etch. (CVE-2009-1890)

A denial of service flaw was found in the Apache mod_deflate module.
This module continued to compress large files until compression was
complete, even if the network connection that requested the content
was closed before compression completed. This would cause mod_deflate
to consume large amounts of CPU if mod_deflate was enabled for a large
file. A similar flaw related to HEAD requests for compressed content
was also fixed. (CVE-2009-1891)


The oldstable distribution (etch), this problem has been fixed in
version 2.2.3-4+etch10.

The other distributions stable (lenny), testing (squeeze) and
unstable (sid) were not affected by the regression.

This advisory also provides updated apache2-mpm-itk packages which
have been recompiled against the new apache2 packages.

Updated packages for apache2-mpm-itk for the s390 architecture are
not included yet. They will be released as soon as they become
available.

We recommend that you upgrade your apache2 (2.2.3-4+etch10), apache2-mpm-itk

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201834-2

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1834-2 (apache2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-itk", ver:"2.2.3-01-2+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.3-4+etch10", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
