# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1839-1 (gst-plugins-good0.10)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64477);
 script_cve_id("CVE-2009-1932");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1839-1 (gst-plugins-good0.10)");

 desc = "The remote host is missing an update to gst-plugins-good0.10
announced via advisory DSA 1839-1.

It has been discovered that gst-plugins-good0.10, the GStreamer plugins
from the good set, are prone to an integer overflow, when processing
a large PNG file. This could lead to the execution of arbitrary code.

For the stable distribution (lenny), this problem has been fixed in
version 0.10.8-4.1~lenny2.

For the oldstable distribution (etch), this problem has been fixed in
version 0.10.4-4+etch1.

Packages for the s390 and hppa architectures will be released once they
are available.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 0.10.15-2.

We recommend that you upgrade your gst-plugins-good0.10 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201839-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1839-1 (gst-plugins-good0.10)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gstreamer0.10-plugins-good-doc", ver:"0.10.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gstreamer0.10-esd", ver:"0.10.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gstreamer0.10-plugins-good", ver:"0.10.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gstreamer0.10-plugins-good-dbg", ver:"0.10.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gstreamer0.10-plugins-good-doc", ver:"0.10.8-4.1~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gstreamer0.10-plugins-good", ver:"0.10.8-4.1~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gstreamer0.10-plugins-good-dbg", ver:"0.10.8-4.1~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gstreamer0.10-esd", ver:"0.10.8-4.1~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
