# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1850-1 (libmodplug)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64562);
 script_cve_id("CVE-2009-1438", "CVE-2009-1513");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1850-1 (libmodplug)");

 desc = "The remote host is missing an update to libmodplug
announced via advisory DSA 1850-1.

Several vulnerabilities have been discovered in libmodplug, the shared
libraries for mod music based on ModPlug. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2009-1438

It was discovered that libmodplug is prone to an integer overflow when
processing a MED file with a crafted song comment or song name.

CVE-2009-1513

It was discovered that libmodplug is prone to a buffer overflow in the
PATinst function, when processing a long instrument name.


For the stable distribution (lenny), these problems have been fixed in
version 1:0.8.4-1+lenny1.

For the oldstable distribution (etch), these problems have been fixed in
version 1:0.7-5.2+etch1.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 1:0.8.7-1.


We recommend that you upgrade your libmodplug packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201850-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1850-1 (libmodplug)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmodplug-dev", ver:"0.7-5.2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmodplug0c2", ver:"0.7-5.2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmodplug-dev", ver:"0.8.4-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmodplug0c2", ver:"0.8.4-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
