# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1852-1 (fetchmail)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64631);
 script_cve_id("CVE-2009-2666");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1852-1 (fetchmail)");

 desc = "The remote host is missing an update to fetchmail
announced via advisory DSA 1852-1.

It was discovered that fetchmail, a full-featured remote mail retrieval
and forwarding utility, is vulnerable to the Null Prefix Attacks Against
SSL/TLS Certificates recently published at the Blackhat conference.
This allows an attacker to perform undetected man-in-the-middle attacks
via a crafted ITU-T X.509 certificate with an injected null byte in the
subjectAltName or Common Name fields.

Note, as a fetchmail user you should always use strict certificate
validation through either these option combinations:
sslcertck ssl sslproto ssl3    (for service on SSL-wrapped ports)
or
sslcertck sslproto tls1        (for STARTTLS-based services)


For the oldstable distribution (etch), this problem has been fixed in
version 6.3.6-1etch2.

For the stable distribution (lenny), this problem has been fixed in
version 6.3.9~rc2-4+lenny1.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 6.3.9~rc2-6.


We recommend that you upgrade your fetchmail packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201852-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1852-1 (fetchmail)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.3.6-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmail", ver:"6.3.6-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.3.9~rc2-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmail", ver:"6.3.9~rc2-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
