# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1854-1 (apr, apr-util)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64632);
 script_cve_id("CVE-2009-2412");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1854-1 (apr, apr-util)");

 desc = "The remote host is missing an update to apr, apr-util
announced via advisory DSA 1854-1.

Matt Lewis discovered that the memory management code in the Apache
Portable Runtime (APR) library does not guard against a wrap-around
during size computations.  This could cause the library to return a
memory area which smaller than requested, resulting a heap overflow
and possibly arbitrary code execution.

For the old stable distribution (etch), this problem has been fixed in
version 1.2.7-9 of the apr package, and version 1.2.7+dfsg-2+etch3 of
the apr-util package.

For the stable distribution (lenny), this problem has been fixed in
version 1.2.12-5+lenny1 of the apr package and version 1.2.12-5+lenny1
of the apr-util package.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you upgrade your APR packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201854-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1854-1 (apr, apr-util)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libapr1", ver:"1.2.7-9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1", ver:"1.2.7+dfsg-2+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr1-dev", ver:"1.2.7-9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dbg", ver:"1.2.7+dfsg-2+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr1-dbg", ver:"1.2.7-9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dev", ver:"1.2.7+dfsg-2+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr1-dev", ver:"1.2.12-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr1-dbg", ver:"1.2.12-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dbg", ver:"1.2.12+dfsg-8+lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dev", ver:"1.2.12+dfsg-8+lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1", ver:"1.2.12+dfsg-8+lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr1", ver:"1.2.12-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
