# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1870-1 (pidgin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64753);
 script_cve_id("CVE-2009-2694", "CVE-2008-2927", "CVE-2009-1376");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1870-1 (pidgin)");

 desc = "The remote host is missing an update to pidgin
announced via advisory DSA 1870-1.

Federico Muttis discovered that libpurple, the shared library that adds
support for various instant messaging networks to the pidgin IM client, is
vulnerable to a heap-based buffer overflow.  This issue exists because of
an incomplete fix for CVE-2008-2927 and CVE-2009-1376.  An attacker can
exploit this by sending two consecutive SLP packets to a victim via MSN.

The first packet is used to create an SLP message object with an offset of
zero, the second packet then contains a crafted offset which hits the
vulnerable code originally fixed in CVE-2008-2927 and CVE-2009-1376 and
allows an attacker to execute arbitrary code.

Note: Users with the Allow only the users below setting are not vulnerable
to this attack. If you can't install the below updates you may want to
set this via Tools->Privacy.


For the stable distribution (lenny), this problem has been fixed in
version 2.4.3-4lenny3.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 2.5.9-1.

We recommend that you upgrade your pidgin packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201870-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1870-1 (pidgin)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-data", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch-dev", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple0", ver:"2.4.3-4lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
