# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1886-1 (iceweasel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64871);
 script_cve_id("CVE-2009-1310", "CVE-2009-3079");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1886-1 (iceweasel)");

 desc = "The remote host is missing an update to iceweasel
announced via advisory DSA 1886-1.

Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2009-3079

moz_bug_r_a4 discovered that a programming error in the FeedWriter
module could lead to the execution of Javascript code with elevated
privileges.

CVE-2009-1310

Prateek Saxena discovered a cross-site scripting vulnerability in
the MozSearch plugin interface.

For the stable distribution (lenny), these problems have been fixed in
version 3.0.6-3.

As indicated in the Etch release notes, security support for the
Mozilla products in the oldstable distribution needed to be stopped
before the end of the regular Etch security maintenance life cycle.
You are strongly encouraged to upgrade to stable or switch to a still
supported browser.

For the unstable distribution (sid), these problems have been fixed in
version 3.0.14-1.

For the experimental distribution, these problems have been fixed in
version 3.5.3-1.

We recommend that you upgrade your iceweasel packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201886-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1886-1 (iceweasel)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"iceweasel-gnome-support", ver:"3.0.6-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dbg", ver:"3.0.6-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel", ver:"3.0.6-3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
