# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1888-1 (openssl, openssl097)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64920);
 script_cve_id("CVE-2009-2409", "CVE-2009-1377", "CVE-2009-1378", "CVE-2009-1379", "CVE-2009-1386", "CVE-2009-1387");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1888-1 (openssl, openssl097)");

 desc = "The remote host is missing an update to openssl, openssl097
announced via advisory DSA 1888-1.

Certificates with MD2 hash signatures are no longer accepted by OpenSSL,
since they're no longer considered cryptographically secure.

For the stable distribution (lenny), this problem has been fixed in
version 0.9.8g-15+lenny5.

For the old stable distribution (etch), this problem has been fixed in
version 0.9.8c-4etch9 for openssl and version 0.9.7k-3.1etch5 for
openssl097.
The OpenSSL 0.9.8 update for oldstable (etch) also provides updated
packages for multiple denial of service vulnerabilities in the
Datagram Transport Layer Security implementation. These fixes were
already provided for Debian stable (Lenny) in a previous point
update. The OpenSSL 0.9.7 package from oldstable (Etch) is not
affected. (CVE-2009-1377, CVE-2009-1378, CVE-2009-1379,
CVE-2009-1386 and CVE-2009-1387)

For the unstable distribution (sid), this problem has been fixed in
version 0.9.8k-5.

We recommend that you upgrade your openssl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201888-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1888-1 (openssl, openssl097)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8c-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7", ver:"0.9.7k-3.1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8c-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7-dbg", ver:"0.9.7k-3.1etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8c-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8c-4etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8g-15+lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8g-15+lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8g-15+lenny5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8g-15+lenny5", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
