# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1895-2 (opensaml2, shibboleth-sp2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66051);
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1895-2 (opensaml2, shibboleth-sp2)");

 desc = "The remote host is missing an update to opensaml2, shibboleth-sp2
announced via advisory DSA 1895-2.

In DSA-1895-1, the xmltooling package was updated to address several
security issues.  It turns out that the change related to SAML
metadata processing for key constraints caused problems when applied
without the matching changes in the opensaml2 and shibboleth-sp2
packages.

For the stable distribution (lenny), this problem has been fixed in
version 2.0-2+lenny1 of the opensaml2 packages, and version
2.0.dfsg1-4+lenny1 of the shibboleth-sp2 packages.

We recommend that you upgrade your opensaml2 and shibboleth-sp2

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201895-2

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1895-2 (opensaml2, shibboleth-sp2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"opensaml2-schemas", ver:"2.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshibsp-doc", ver:"2.0.dfsg1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"shibboleth-sp2-schemas", ver:"2.0.dfsg1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsaml2-doc", ver:"2.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"opensaml2-tools", ver:"2.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshibsp1", ver:"2.0.dfsg1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsaml2-dev", ver:"2.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-shib2", ver:"2.0.dfsg1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsaml2", ver:"2.0-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libshibsp-dev", ver:"2.0.dfsg1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
