# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1911-1 (pygresql)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66055);
 script_cve_id("CVE-2009-2940");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1911-1 (pygresql)");

 desc = "The remote host is missing an update to pygresql
announced via advisory DSA 1911-1.


It was discovered that pygresql, a PostgreSQL module for Python, was
missing a function to call PQescapeStringConn(). This is needed, because
PQescapeStringConn() honours the charset of the connection and prevents
insufficient escaping, when certain multibyte character encodings are
used. The new function is called pg_escape_string(), which takes the
database connection as a first argument. The old function
escape_string() has been preserved as well for backwards compatibility.

Developers using these bindings are encouraged to adjust their code to
use the new function.


For the stable distribution (lenny), this problem has been fixed in
version 1:3.8.1-3+lenny1.

For the oldstable distribution (etch), this problem has been fixed in
version 1:3.8.1-1etch2.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 1:4.0-1.


We recommend that you upgrade your pygresql packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201911-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1911-1 (pygresql)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-pygresql", ver:"3.8.1-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-pygresql", ver:"3.8.1-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-pygresql-dbg", ver:"3.8.1-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
