# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1921-1 (expat)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66145);
 script_cve_id("CVE-2009-2625");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1921-1 (expat)");

 desc = "The remote host is missing an update to expat
announced via advisory DSA 1921-1.


Peter Valchev discovered an error in expat, an XML parsing C library,
when parsing certain UTF-8 sequences, which can be exploited to crash an
application using the library.

For the old stable distribution (etch), this problem has been fixed in
version 1.95.8-3.4+etch1.

For the stable distribution (lenny), this problem has been fixed in
version 2.0.1-4+lenny1.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem will be fixed soon.


We recommend that you upgrade your expat packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201921-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1921-1 (expat)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libexpat1-dev", ver:"1.95.8-3.4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libexpat1", ver:"1.95.8-3.4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"expat", ver:"1.95.8-3.4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"expat", ver:"2.0.1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libexpat1", ver:"2.0.1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libexpat1-dev", ver:"2.0.1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib64expat1", ver:"2.0.1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib64expat1-dev", ver:"2.0.1-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
