# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1942-1 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66454);
 script_cve_id("CVE-2009-1268", "CVE-2008-1829", "CVE-2009-2560", "CVE-2009-2562", "CVE-2009-3241", "CVE-2009-3550", "CVE-2009-3829");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1942-1 (wireshark)");

 desc = "The remote host is missing an update to wireshark
announced via advisory DSA 1942-1.

Several remote vulnerabilities have been discovered in the Wireshark
network traffic analyzer, which may lead to the execution of arbitrary
code or denial of service. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-2560

A NULL pointer dereference was found in the RADIUS dissector.

CVE-2009-3550

A NULL pointer dereference was found in the DCERP/NT dissector.

CVE-2009-3829

An integer overflow was discovered in the ERF parser.

This update also includes fixes for three minor issues, which were
scheduled for the next stable point update. (CVE-2008-1829,
CVE-2009-2562, CVE-2009-3241). Also CVE-2009-1268 was fixed for Etch.
Since this security update was issued prior to the release of the
point update, the fixes were included.

For the old stable distribution (etch), this problem has been fixed in
version 0.99.4-5.etch.4.

For the stable distribution (lenny), this problem has been fixed in
version 1.0.2-3+lenny7.

For the unstable distribution (sid) these problems have been fixed in
version 1.2.3-1.

We recommend that you upgrade your Wireshark packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201942-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1942-1 (wireshark)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ethereal-common", ver:"0.99.4-5.etch.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-dev", ver:"0.99.4-5.etch.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal", ver:"0.99.4-5.etch.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tshark", ver:"0.99.4-5.etch.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-common", ver:"0.99.4-5.etch.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark", ver:"0.99.4-5.etch.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-dev", ver:"0.99.4-5.etch.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tethereal", ver:"0.99.4-5.etch.4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tshark", ver:"1.0.2-3+lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark", ver:"1.0.2-3+lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-common", ver:"1.0.2-3+lenny7", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-dev", ver:"1.0.2-3+lenny7", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
