# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1954-1 (cacti)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66592);
 script_cve_id("CVE-2007-3112", "CVE-2007-3113", "CVE-2009-4032", "CVE-2009-4112");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1954-1 (cacti)");

 desc = "The remote host is missing an update to cacti
announced via advisory DSA 1954-1.

Several vulnerabilities have been found in cacti, a frontend to rrdtool
for monitoring systems and services. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2007-3112, CVE-2007-3113

It was discovered that cacti is prone to a denial of service via the
graph_height, graph_width, graph_start and graph_end parameters.
This issue only affects the oldstable (etch) version of cacti.

CVE-2009-4032

It was discovered that cacti is prone to several cross-site scripting
attacks via different vectors.

CVE-2009-4112

It has been discovered that cacti allows authenticated administrator
users to gain access to the host system by executing arbitrary commands
via the Data Input Method for the Linux - Get Memory Usage setting.

There is no fix for this issue at this stage. Upstream will implement a
whitelist policy to only allow certain safe commands. For the moment,
we recommend that such access is only given to trusted users and that
the options Data Input and User Administration are otherwise
deactivated.


For the oldstable distribution (etch), these problems have been fixed in
version 0.8.6i-3.6.

For the stable distribution (lenny), this problem has been fixed in
version 0.8.7b-2.1+lenny1.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 0.8.7e-1.1.


We recommend that you upgrade your cacti packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201954-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1954-1 (cacti)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cacti", ver:"0.8.6i-3.6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cacti", ver:"0.8.7b-2.1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
