# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1982-1 (hybserv)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66804);
 script_cve_id("CVE-2010-0303");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1982-1 (hybserv)");

 desc = "The remote host is missing an update to hybserv
announced via advisory DSA 1982-1.


Julien Cristau discovered that hybserv, a daemon running IRC services
for IRCD-Hybrid, is prone to a denial of service attack via the commands
option.


For the stable distribution (lenny), this problem has been fixed in
version 1.9.2-4+lenny2.

Due to a bug in the archive system, it is not possible to release the
fix for the oldstable distribution (etch) simultaneously. Therefore,
etch will be fixed in version 1.9.2-4+etch1 as soon as it becomes
available.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 1.9.2-4.1.


We recommend that you upgrade your hybserv packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201982-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1982-1 (hybserv)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hybserv", ver:"1.9.2-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
