# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1987-1 (lighttpd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66806);
 script_cve_id("CVE-2010-0295");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1987-1 (lighttpd)");

 desc = "The remote host is missing an update to lighttpd
announced via advisory DSA 1987-1.

Li Ming discovered that lighttpd, a small and fast webserver with minimal
memory footprint, is vulnerable to a denial of service attack due to bad
memory handling.  Slowly sending very small chunks of request data causes
lighttpd to allocate new buffers for each read instead of appending to
old ones.  An attacker can abuse this behaviour to cause denial of service
conditions due to memory exhaustion.


For the oldstable distribution (etch), this problem has been fixed in
version 1.4.13-4etch12.

For the stable distribution (lenny), this problem has been fixed in
version 1.4.19-5+lenny1.

For the testing (squeeze) and unstable (sid) distribution, this problem
will be fixed soon.


We recommend that you upgrade your lighttpd packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201987-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1987-1 (lighttpd)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"lighttpd-doc", ver:"1.4.13-4etch12", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-mysql-vhost", ver:"1.4.13-4etch12", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd", ver:"1.4.13-4etch12", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-magnet", ver:"1.4.13-4etch12", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-webdav", ver:"1.4.13-4etch12", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-trigger-b4-dl", ver:"1.4.13-4etch12", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-cml", ver:"1.4.13-4etch12", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-doc", ver:"1.4.19-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-cml", ver:"1.4.19-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd", ver:"1.4.19-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-webdav", ver:"1.4.19-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-mysql-vhost", ver:"1.4.19-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-magnet", ver:"1.4.19-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lighttpd-mod-trigger-b4-dl", ver:"1.4.19-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
