# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1998-1 (kdelibs)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66952);
 script_cve_id("CVE-2009-0689");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1998-1 (kdelibs)");

 desc = "The remote host is missing an update to kdelibs
announced via advisory DSA 1998-1.

Maksymilian Arciemowicz discovered a buffer overflow in the internal
string routines of the KDE core libraries, which could lead to the
execution of arbitrary code.

For the stable distribution (lenny), this problem has been fixed in
version 4:3.5.10.dfsg.1-0lenny4.

For the unstable distribution (sid), this problem has been fixed in
version 4:3.5.10.dfsg.1-3.

We recommend that you upgrade your kdelibs packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201998-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1998-1 (kdelibs)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.10.dfsg.1-0lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.10.dfsg.1-0lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.10.dfsg.1-0lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.10.dfsg.1-0lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.10.dfsg.1-0lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.10.dfsg.1-0lenny4", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
