# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 2000-1 (ffmpeg-debian)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66953);
 script_cve_id("CVE-2009-4631", "CVE-2009-4632", "CVE-2009-4633", "CVE-2009-4634", "CVE-2009-4635", "CVE-2009-4636", "CVE-2009-4637", "CVE-2009-4638", "CVE-2009-4640");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 2000-1 (ffmpeg-debian)");

 desc = "The remote host is missing an update to ffmpeg-debian
announced via advisory DSA 2000-1.

Several vulnerabilities have been discovered in ffmpeg, a multimedia
player, server and encoder, which also provides a range of multimedia
libraries used in applications like MPlayer:

Various programming errors in container and codec implementations
may lead to denial of service or the execution of arbitrary code
if the user is tricked into opening a malformed media file or stream.

Affected and updated have been the implementations of the following
codecs and container formats:

- - the Vorbis audio codec
- - the Ogg container implementation
- - the FF Video 1 codec
- - the MPEG audio codec
- - the H264 video codec
- - the MOV container implementation
- - the Oggedc container implementation

For the stable distribution (lenny), these problems have been fixed in
version 0.svn20080206-18+lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 4:0.5+svn20090706-5.

We recommend that you upgrade your ffmpeg packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%202000-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 2000-1 (ffmpeg-debian)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ffmpeg-doc", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavutil-dev", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavutil49", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libswscale-dev", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostproc51", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostproc-dev", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavformat52", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavdevice52", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavdevice-dev", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavcodec51", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ffmpeg", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ffmpeg-dbg", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavformat-dev", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libswscale0", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavcodec-dev", ver:"0.svn20080206-18+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
