# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 2011-1 (dpkg)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(67034);
 script_cve_id("CVE-2010-0396");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 2011-1 (dpkg)");

 desc = "The remote host is missing an update to dpkg
announced via advisory DSA 2011-1.

William Grant discovered that the dpkg-source component of dpkg, the
low-level infrastructure for handling the installation and removal of
Debian software packages, is vulnerable to path traversal attacks.
A specially crafted Debian source package can lead to file modification
outside of the destination directory when extracting the package content.


For the stable distribution (lenny), this problem has been fixed in
version 1.14.29.

For the testing (squeeze) and unstable (sid) distribution this problem
will be fixed soon.

We recommend that you upgrade your dpkg packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%202011-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 2011-1 (dpkg)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"dpkg-dev", ver:"1.14.29", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dpkg", ver:"1.14.29", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dselect", ver:"1.14.29", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
