# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 213-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53453);
 script_bugtraq_id(6431);
 script_cve_id("CVE-2002-1363");
 script_version ("$");
 name = "Debian Security Advisory DSA 213-1 (libpng, libpng3)";
 script_name(name);

 desc = "The remote host is missing an update to libpng, libpng3
announced via advisory DSA 213-1.

Glenn Randers-Pehrson discovered a problem in connection with 16-bit
samples from libpng, an interface for reading and writing PNG
(Portable Network Graphics) format files.  The starting offsets for
the loops are calculated incorrectly which causes a buffer overrun
beyond the beginning of the row buffer.

For the current stable distribution (woody) this problem has been
fixed in version 1.0.12-3.woody.3 for libpng and in version
1.2.1-1.1.woody.3 for libpng3.

For the old stable distribution (potato) this problem has been fixed
in version 1.0.5-1.1 for libpng.  There are no other libpng packages.

For the unstable distribution (sid) this problem has been fixed in
version 1.0.12-7 for libpng and in version 1.2.5-8 for libpng3.

We recommend that you upgrade your libpng packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20213-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 213-1 (libpng, libpng3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpng2", ver:"1.0.5-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng2-dev", ver:"1.0.5-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng2", ver:"1.0.12-3.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng2-dev", ver:"1.0.12-3.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng-dev", ver:"1.2.1-1.1.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpng3", ver:"1.2.1-1.1.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
