# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 257-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53859);
 script_version ("$");
 name = "Debian Security Advisory DSA 257-1 (sendmail)";
 script_name(name);

 desc = "The remote host is missing an update to sendmail
announced via advisory DSA 257-1.

Mark Dowd of ISS X-Force found a bug in the header parsing routines
of sendmail: it could overflow a buffer overflow when encountering
addresses with very long comments. Since sendmail also parses headers
when forwarding emails this vulnerability can hit mail-servers which do
not deliver the email as well.

This has been fixed in upstream release 8.12.8, version 8.12.3-5 of
the package for Debian GNU/Linux 3.0/woody and version 8.9.3-25 of the
package for Debian GNU/Linux 2.2/potato.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20257-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 257-1 (sendmail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sendmail", ver:"8.9.3-25", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sendmail-doc", ver:"8.12.3-5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sendmail", ver:"8.12.3-5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmilter-dev", ver:"8.12.3-5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
