# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 279-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53348);
 script_bugtraq_id(7293);
 script_cve_id("CVE-2003-0202");
 script_version ("$");
 name = "Debian Security Advisory DSA 279-1 (metrics)";
 script_name(name);

 desc = "The remote host is missing an update to metrics
announced via advisory DSA 279-1.

Paul Szabo and Matt Zimmerman discoverd two similar problems in
metrics, a tools for software metrics.  Two scripts in this package,
halstead and gather_stats, open temporary files without taking
appropriate security precautions.  halstead is installed as a user
program, while gather_stats is only used in an auxiliary script
included in the source code.  These vulnerabilities could allow a
local attacker to overwrite files owned by the user running the
scripts, including root.

The stable distribution (woody) is not affected since it doesn't
contain a metrics package anymore.

For the old stable distribution (potato) this problem has been fixed
in version 1.0-1.1.

The unstable distribution (sid) is not affected since it doesn't
contain a metrics package anymore.

We recommend that you upgrade your metrics package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20279-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 279-1 (metrics)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"metrics", ver:"1.0-1.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
