# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 283-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53352);
 script_cve_id("CVE-2003-0173");
 script_version ("$");
 name = "Debian Security Advisory DSA 283-1 (xfsdump)";
 script_name(name);

 desc = "The remote host is missing an update to xfsdump
announced via advisory DSA 283-1.

Ethan Benson discovered a problem in xfsdump, that contains
administrative utilities for the XFS filesystem.  When filesystem
quotas are enabled xfsdump runs xfsdq to save the quota information
into a file at the root of the filesystem being dumped.  The manner in
which this file is created is unsafe.

While fixing this, a new option ``-f path'' has been added to xfsdq(8)
to specify an output file instead of using the standard output stream.
This file is created by xfsdq and xfsdq will fail to run if it exists
already.  The file is also created with a more appropriate mode than
whatever the umask happened to be when xfsdump(8) was run.

For the stable distribution (woody) this problem has been fixed in
version 2.0.1-2.

The old stable distribution (potato) is not affected since it doesn't
contain xfsdump packages.

For the unstable distribution (sid) this problem has been fixed in
version 2.2.8-1.

We recommend that you upgrade your lpr package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20283-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 283-1 (xfsdump)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xfsdump", ver:"2.0.1-2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
