# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 357-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53646);
 script_bugtraq_id(8315);
 script_cve_id("CVE-2003-0466");
 script_version ("$");
 name = "Debian Security Advisory DSA 357-1 (wu-ftpd)";
 script_name(name);

 desc = "The remote host is missing an update to wu-ftpd
announced via advisory DSA 357-1.

iSEC Security Research reports that wu-ftpd contains an off-by-one bug
in the fb_realpath function which could be exploited by a logged-in user
(local or anonymous) to gain root privileges. A demonstration exploit is
reportedly available.

For the current stable distribution (woody) this problem has been fixed
in version 2.6.2-3woody1.

For the unstable distribution (sid) an update will be available shortly.

We recommend you upgrade your wu-ftpd package immediately.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20357-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 357-1 (wu-ftpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wu-ftpd-academ", ver:"2.6.2-3woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wu-ftpd", ver:"2.6.2-3woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
