# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 360-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53649);
 script_cve_id("CVE-2003-0581", "CVE-2003-0625");
 script_version ("$");
 name = "Debian Security Advisory DSA 360-1 (xfstt)";
 script_name(name);

 desc = "The remote host is missing an update to xfstt
announced via advisory DSA 360-1.

xfstt, a TrueType font server for the X window system was found to
contain two classes of vulnerabilities:

- - CVE-2003-0581: a remote attacker could send requests crafted to
trigger any of several buffer overruns, causing a denial of service or
possibly executing arbitrary code on the server with the privileges
of the 'nobody' user.

- - CVE-2003-0625: certain invalid data sent during the connection
handshake could allow a remote attacker to read certain regions of
memory belonging to the xfstt process.  This information could be
used for fingerprinting, or to aid in exploitation of a different
vulnerability.

For the current stable distribution (woody) these problems have been
fixed in version 1.2.1-3.

For the unstable distribution (sid), CVE-2003-0581 is fixed in xfstt
1.5-1, and CVE-2003-0625 will be fixed soon.

We recommend that you update your xfstt package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20360-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 360-1 (xfstt)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xfstt", ver:"1.2.1-3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
