# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 361-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53650);
 script_cve_id("CVE-2003-0459", "CVE-2003-0370");
 script_version ("$");
 name = "Debian Security Advisory DSA 361-1 (kdelibs)";
 script_name(name);

 desc = "The remote host is missing an update to kdelibs
announced via advisory DSA 361-1.

Two vulnerabilities were discovered in kdelibs:

- - CVE-2003-0459: KDE Konqueror for KDE 3.1.2 and earlier does not
remove authentication credentials from URLs of the
'user:password@host' form in the HTTP-Referer header, which could
allow remote web sites to steal the credentials for pages that link
to the sites.

- - CVE-2003-0370: Konqueror Embedded and KDE 2.2.2 and earlier does not
validate the Common Name (CN) field for X.509 Certificates, which
could allow remote attackers to spoof certificates via a
man-in-the-middle attack.

These vulnerabilities are described in the following security
advisories from KDE:

http://www.kde.org/info/security/advisory-20030729-1.txt
http://www.kde.org/info/security/advisory-20030602-1.txt

For the current stable distribution (woody) these problems have been
fixed in version 2.2.2-13.woody.8.

For the unstable distribution (sid) these problems have been fixed in
version 4:3.1.3-1.

We recommend that you update your kdelibs package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20361-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 361-1 (kdelibs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs3-doc", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dev", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-bin", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-cups", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts-alsa", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts-dev", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid-alsa", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid-dev", ver:"2.2.2-13.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
